// -*- C++ -*-
// 
// SimplIC3: a "simple" implementation of IC3 (and other SAT-based algorithms)
// for finite-state functional transition systems
//
// And-inverter graphs with local 2-level rewriting
//
// Author: Alberto Griggio <griggio@fbk.eu>
// See LICENSE.txt for copyright/licensing information
// See CREDITS.txt for other credits
//
// Derived from ABC by Alan Mishchenko. Copyright of original code follows
//
// ABC: System for Sequential Synthesis and Verification
// 
// http://www.eecs.berkeley.edu/~alanmi/abc/
// 
// Copyright (c) The Regents of the University of California. All rights
// reserved.
// 
// Permission is hereby granted, without written agreement and without license
// or royalty fees, to use, copy, modify, and distribute this software and its
// documentation for any purpose, provided that the above copyright notice and
// the following two paragraphs appear in all copies of this software.
// 
// IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
// DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
// OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY
// OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 
// THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
// INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
// AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON
// AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
// PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

#ifndef SIMPLIC3_AIGSOPDATA_H
#define SIMPLIC3_AIGSOPDATA_H

namespace simplic3 { namespace aigsopdata {

/// Table of precomputed SOPs for Boolean formulas with up to 4 inputs
/// x0, x1, x2, x3.
///
/// The SOPs are stored in a big array of strings, in a very compact format.
/// When decoded, each cube is represented by an integer Z such that
///       Z = l0 + 3 * l1 + 9 * l2 + 27 * l3
///       
/// Each li represents either a literal in the cube or a "don't care",
/// as follows:
///    if li % 3 == 0, then li represents -xi
///    if li % 3 == 1, then li represents  xi
///    otherwise, li is a padding that should be ignored
///
/// In the encoded format, each SOP is represented by a sequence of
/// non-whitespace characters, and the different SOPs are separated by a ' '
/// char. Each character corresponds to an integer (that encodes the Z value
/// of a SOP described above) according to the translation table defined
/// below.
///
extern const char *data[];

/// translation table for mapping characters in the SOP data to integers
static const char translation_table[82] =
    "!#&()*+,-.0123456789:;<=>?"
    "ABCDEFGHIJKLMNOPQRSTUVWXYZ[]"
    "abcdefghijklmnopqrstuvwxyz|";


}} // namespace simplic3::aigsopdata

#endif // SIMPLIC3_AIGSOPDATA_H
