// -*- C++ -*-
// 
// SimplIC3: a "simple" implementation of IC3 (and other SAT-based algorithms)
// for finite-state functional transition systems
//
// Hash tables
//
// Author: Alberto Griggio <griggio@fbk.eu>
// See LICENSE.txt for copyright/licensing information
// See CREDITS.txt for other credits
//

#ifndef SIMPLIC3_HASHMAP_H
#define SIMPLIC3_HASHMAP_H

#include <stdlib.h>

#define HAVE_TR1_UNORDERED_MAP

#ifdef HAVE_TR1_UNORDERED_MAP
#  include <tr1/unordered_map>
#  include <tr1/unordered_set>

#define HashMap std::tr1::unordered_map
#define HashSet std::tr1::unordered_set

#else // HAVE_TR1_UNORDERED_MAP
#  include <unordered_map>
#  include <unordered_set>

#define HashMap std::unordered_map
#define HashSet std::unordered_set

#endif // HAVE_TR1_UNORDERED_MAP

namespace simplic3 {

template <class T>
struct Hasher {
    size_t operator()(const T &t) const { return t.hash(); }
};

} // namespace simplic3

#endif // SIMPLIC3_HASHMAP_H
