// -*- C++ -*-
// 
// SimplIC3: a "simple" implementation of IC3 (and other SAT-based algorithms)
// for finite-state functional transition systems
//
// K-induction engine
//
// Author: Alberto Griggio <griggio@fbk.eu>
// See LICENSE.txt for copyright/licensing information
// See CREDITS.txt for other credits
//

#ifndef SIMPLIC3_KINDUCTION_H
#define SIMPLIC3_KINDUCTION_H

#include "simplic3/model.h"
#include "simplic3/unroll.h"
#include "simplic3/satsolver.h"
#include "simplic3/cnf.h"
#include "simplic3/miscutils.h"
#include "simplic3/opts.h"
#include "simplic3/prover.h"

namespace simplic3 {

class KInduction: public Prover {
public:
    KInduction(Options opts, Model *model, size_t prop_idx);
    ~KInduction();

    Result prove();
    Stats get_stats();

    void set_safe_bound_callback(const SafeBoundCallback *cb);

    bool get_counterexample_trace(std::vector<AigList> *out);
    bool get_final_invariant(std::vector<AigList> *out) { return false; }

private:
    Options opts_;
    Model *model_;
    size_t prop_idx_;
    SatSolverFactory *factory_;
    ModelUnroll un_;

    const SafeBoundCallback *cb_;

    std::vector<AigList> cex_trace_;
    int verb_;
    int min_k_;
    int max_k_;

    size_t reached_depth_;
    size_t num_simple_path_constraints_;
    double total_time_;
    double clausify_time_;
    double base_time_;
    double step_time_;
};

} // namespace simplic3

#endif // SIMPLIC3_KINDUCTION_H
