// -*- C++ -*-
// 
// SimplIC3: a "simple" implementation of IC3 (and other SAT-based algorithms)
// for finite-state functional transition systems
//
// Options handling
//
// Author: Alberto Griggio <griggio@fbk.eu>
// See LICENSE.txt for copyright/licensing information
// See CREDITS.txt for other credits
//

#ifndef SIMPLIC3_OPTS_H
#define SIMPLIC3_OPTS_H

#include <vector>
#include <string>
#include <iostream>
#include <exception>

namespace simplic3 {

struct Options {
    std::string algorithm;
    std::string solver;
    bool use_relind;
    bool short_cex;
    int verbosity;
    int prop_unroll;
    int solver_reset_freq;
    int max_trans_solvers;
    bool sat_preprocess;
    bool cnf_simple;
    bool use_ctg;
    int bmc_maxdepth;
    int bmc_mindepth;
    bool aic3_ref_bmc;
    int simpl_max_td_depth;
    int simpl_max_sim_depth;
    int simpl_min_td_depth;

    Options();
    
    struct error: public std::exception {
        error(const std::string &msg): msg_(msg) {}
        ~error() throw() {}
        const char *what() { return msg_.c_str(); }
        const std::string msg_;
    }; 
    std::vector<std::string> parse(const std::vector<std::string> &args);
    std::vector<std::string> parse(int argc, const char **argv);
    void print_help(std::ostream &out, const std::string &msg="");

    std::string get(const std::string &opt);
    bool set(const std::string &opt, const std::string &val);
};

} // namespace simplic3

#endif // SIMPLIC3_OPTS_H
