// -*- C++ -*-
// 
// SimplIC3: a "simple" implementation of IC3 (and other SAT-based algorithms)
// for finite-state functional transition systems
//
// Picosat SAT solver backend
//
// Author: Alberto Griggio <griggio@fbk.eu>
// See LICENSE.txt for copyright/licensing information
// See CREDITS.txt for other credits
//

#ifndef SIMPLICI3_PICOSATSOLVER_H
#define SIMPLICI3_PICOSATSOLVER_H

#include "simplic3/satsolver.h"
extern "C" {
#include "picosat.h"
}

namespace simplic3 {

class PicosatSolver: public SatSolver {
public:
    PicosatSolver();
    ~PicosatSolver();

    SatVar new_var();
    void add_clause(const SatLitList &cls);
    bool solve(const SatLitList &assumps);
    SatValue get_model_value(SatLit l);
    void get_unsat_core(SatLitSet &out);

    void push();
    void pop();

    void set_frozen(SatVar v) {}

    int reset_frequency() const { return 2500; }
    
private:
    void add_clause(const SatLitList &cls, SatLit label);

    PicoSAT *dpll_;
    SatLit gclabel_;
    std::vector<int> assumptions_;
};


class PicosatSolverFactory: public SatSolverFactory {
public:
    SatSolver *new_satsolver();
};


} // namespace simplic3

#endif // SIMPLICI3_PICOSATSOLVER_H
