// -*- C++ -*-
// 
// SimplIC3: a "simple" implementation of IC3 (and other SAT-based algorithms)
// for finite-state functional transition systems
//
// Generic Prover interface
//
// Author: Alberto Griggio <griggio@fbk.eu>
// See LICENSE.txt for copyright/licensing information
// See CREDITS.txt for other credits
//

#ifndef SIMPLIC3_PROVER_H
#define SIMPLIC3_PROVER_H

#include "simplic3/model.h"
#include "simplic3/opts.h"
#include "simplic3/miscutils.h"

namespace simplic3 {

class Prover {
public:
    class SafeBoundCallback {
    public:
        virtual ~SafeBoundCallback() {}
        virtual void operator()(int k) const = 0;
    };
    
    enum Result { FALSIFIED = 0, VERIFIED, UNKNOWN };
    virtual ~Prover() {}
    virtual Result prove() = 0;
    virtual Stats get_stats() = 0;

    virtual void set_safe_bound_callback(const SafeBoundCallback *cb) {}

    virtual bool get_counterexample_trace(std::vector<AigList> *out) = 0;
    virtual bool get_final_invariant(std::vector<AigList> *out) = 0;

    static Prover *get(const std::string &name,
                       const Options &opts, Model *model, size_t property);
    static std::vector<std::string> getnames();
};


} // namespace simplic3

#endif // SIMPLIC3_PROVER_H
