// -*- C++ -*-
// 
// SimplIC3: a "simple" implementation of IC3 (and other SAT-based algorithms)
// for finite-state functional transition systems
//
// Model simplification via temporal decomposition
//
// Author: Alberto Griggio <griggio@fbk.eu>
// See LICENSE.txt for copyright/licensing information
// See CREDITS.txt for other credits
//

#ifndef SIMPLIC3_TDECOMP_H
#define SIMPLIC3_TDECOMP_H

#include "simplic3/model.h"
#include "simplic3/opts.h"

namespace simplic3 {

class TemporalDecomp {
public:
    TemporalDecomp(Options opts, Model *model);
    ~TemporalDecomp();

    Model *simplify();
    void get_trace(const std::vector<AigList> &trace,
                   std::vector<AigList> &out);
    size_t get_unroll_depth() const;

private:
    typedef HashMap<Aig, Aig> SubstMap;
    
    Aig apply_subst(AigManager *mgr, Aig a, SubstMap &cache);
    void apply_coi(Model &src, Model &dst);

    Options opts_;
    Model *model_;
    Model *simplmodel_;
    int max_td_depth_;
    int max_sim_depth_;
    int verb_;

    size_t unroll_depth_;
};

} // namespace simplic3

#endif // SIMPLIC3_TDECOMP_H
