// -*- C++ -*-
// 
// SimplIC3: a "simple" implementation of IC3 (and other SAT-based algorithms)
// for finite-state functional transition systems
//
// Model unrolling
//
// Author: Alberto Griggio <griggio@fbk.eu>
// See LICENSE.txt for copyright/licensing information
// See CREDITS.txt for other credits
//

#ifndef SIMPLIC3_UNROLL_H
#define SIMPLIC3_UNROLL_H

#include "simplic3/model.h"

namespace simplic3 {

class ModelUnroll {
public:
    ModelUnroll(Model *model, bool internal_mgr=false);

    Aig unroll(Aig a, int depth);

    AigManager *aig_manager()
    { return internal_mgr_ ? &mgr_ : model_->aig_manager(); }

protected:
    Model *model_;
    AigManager mgr_;
    bool internal_mgr_;

    struct Key {
        Aig a;
        int k;

        Key(Aig aa=0, int kk=0): a(aa), k(kk) {}
        
        size_t hash() const { return size_t(a) + size_t(k); }
        bool operator==(const Key &o) const { return a == o.a && k == o.k; }
    };
    typedef HashMap<Key, Aig, Hasher<Key> > UnrollMap;
    UnrollMap cache_;

    int nextvar_;
};

} // namespace simplic3

#endif // SIMPLIC3_UNROLL_H
