// -*- C++ -*-
// 
// SimplIC3: a "simple" implementation of IC3 (and other SAT-based algorithms)
// for finite-state functional transition systems
//
// IC3 with lazy abstraction
//
// Author: Alberto Griggio <griggio@fbk.eu>
// See LICENSE.txt for copyright/licensing information
// See CREDITS.txt for other credits
//

#ifndef SIMPLIC3_AIC3_H
#define SIMPLIC3_AIC3_H

#include "simplic3/ic3.h"

namespace simplic3 {

class AbsIC3: public IC3 {
    typedef IC3 Super;
public:
    AbsIC3(Options opts, Model *model, size_t prop_idx);
    ~AbsIC3();

    Stats get_stats();
    
private:
    void new_frame();
    void get_next(const Cube &c, Cube *out, int time);
    bool is_cex(ProofObligationQueue &q);
    bool refine_cex(ProofObligation *s);
    bool refine_cex_ic3(ProofObligation *s);
    bool refine_cex_bmc(ProofObligation *s);
    
    Aig get_frame_formula(const FrameList &frames, int time, bool next);
    
    std::vector<AigSet> absvars_;
    bool bmc_ref_preprocess_;

    size_t num_refinements_;
    double refinement_time_;
};

} // namespace simplic3

#endif // SIMPLIC3_AIC3_H
