// -*- C++ -*-
// 
// SimplIC3: a "simple" implementation of IC3 (and other SAT-based algorithms)
// for finite-state functional transition systems
//
// CNF conversion routines
//
// Author: Alberto Griggio <griggio@fbk.eu>
// See LICENSE.txt for copyright/licensing information
// See CREDITS.txt for other credits
//

#ifndef SIMPLIC3_CNF_H
#define SIMPLIC3_CNF_H

#include "simplic3/model.h"
#include "simplic3/satsolver.h"

namespace simplic3 {

class CnfConv {
public:
    CnfConv(Model *model, SatSolver *dpll, bool simple=false,
            bool freeze_all=false);
    ~CnfConv();

    SatLit clausify(Aig a);
    SatLit lookup(Aig a);
    void set_label(Aig a, SatVar v);

protected:
    class ClauseSink {
    public:
        ClauseSink(CnfConv *parent):
            parent_(parent), toplit(satLit_Undef) {}

        bool has_label(Aig a);
        void set_label(Aig a);
        void set_label(Aig a, int var);
        void begin_clause();
        void add_literal(Aig a, bool negated);
        void end_clause();
        void toplevel_literal(Aig a, bool negated);

        SatLit toplit;
        CnfConv *parent_;
    };
    friend class ClauseSink;

    Model *model_;
    AigManager *mgr_;
    SatSolver *dpll_;
    bool simple_;
    bool freeze_all_;

    typedef HashMap<Aig, SatVar> CnfConvMap;
    CnfConvMap cache_;
    
    SatLitList clause_;
};

} // namespace simplic3

#endif // SIMPLIC3_CNF_H
