// -*- C++ -*-
// 
// SimplIC3: a "simple" implementation of IC3 (and other SAT-based algorithms)
// for finite-state functional transition systems
//
// Helper structures for the IC3 engine
//
// Author: Alberto Griggio <griggio@fbk.eu>
// See LICENSE.txt for copyright/licensing information
// See CREDITS.txt for other credits
//

#include "ic3helpers.h"

namespace simplic3 {

//-----------------------------------------------------------------------------
// ProofObligation
//-----------------------------------------------------------------------------

ProofObligation::ProofObligation(const Cube *c, int time, int idx):
    cube_(c),
    time_(time),
    idx_(idx),
    next_(NULL)
{
}


size_t ProofObligation::length() const
{
    size_t ret = 1;
    for (ProofObligation *n = next_; n != NULL; n = n->next_) {
        ++ret;
    }
    return ret;
}


//-----------------------------------------------------------------------------
// FrameCube
//-----------------------------------------------------------------------------

FrameCube::FrameCube():
    abstraction_(0),
    active_(true)
{
}


FrameCube::FrameCube(const Cube &cube):
    cube_(cube), abstraction_(0),
    active_(true)
{
    calc_abstraction();
}


bool FrameCube::subsumes(const FrameCube &other) const
{
    if (other.size() < size() || (abstraction() & ~other.abstraction()) != 0) {
        return false;
    }

    for (size_t i = 0; i < size(); ++i) {
        // search for c[i]
        for (size_t j = 0; j < other.size(); ++j) {
            if ((*this)[i] == other[j]) {
                goto found;
            }
        }
        return false;
      found:;
    }

    return true;    
}


void FrameCube::calc_abstraction()
{
    abstraction_ = 0;
    for (size_t i = 0; i < size(); i++) {
        abstraction_ |= 1 << (AigManager::aig_id((*this)[i]) & 31);
    }
}


} // namespace simplic3
