// -*- C++ -*-
// 
// SimplIC3: a "simple" implementation of IC3 (and other SAT-based algorithms)
// for finite-state functional transition systems
//
// MiniSat SAT solver backend
//
// Author: Alberto Griggio <griggio@fbk.eu>
// See LICENSE.txt for copyright/licensing information
// See CREDITS.txt for other credits
//

#ifndef SIMPLIC3_MINISATSOLVER_H
#define SIMPLIC3_MINISATSOLVER_H

#include "simplic3/satsolver.h"
#include "core/Solver.h"
#include "simp/SimpSolver.h"

namespace simplic3 {

class MinisatSolver: public SatSolver {
public:
    MinisatSolver(bool simp);
    ~MinisatSolver();

    SatVar new_var();
    void add_clause(const SatLitList &cls);
    bool solve(const SatLitList &assumps);
    SatValue get_model_value(SatLit l);
    void get_unsat_core(SatLitSet &out);

    void push();
    void pop();

    void set_frozen(SatVar v);
    void unfreeze_all();
    void preprocess();

    int reset_frequency() const { return 5000; }

    uint64_t get_last_propagations() const { return dpll_->propagations; }
    uint64_t get_last_conflicts() const { return dpll_->conflicts; }
    uint64_t get_last_decisions() const { return dpll_->decisions; }
    
private:
    void add_clause(const SatLitList &cls, SatLit label);

    Minisat::SimpSolver *dpll_;
    bool simp_;
    Minisat::vec<Minisat::Lit> tmplist_;
    bool in_push_;
    SatLit gclabel_;
    Minisat::Lit pushlbl_;
};


class MinisatSolverFactory: public SatSolverFactory {
public:
    MinisatSolverFactory(bool simp);
    SatSolver *new_satsolver();

private:
    bool simp_;
};


} // namespace simplic3

#endif // SIMPLIC3_MINISATSOLVER_H
