// -*- C++ -*-
// 
// SimplIC3: a "simple" implementation of IC3 (and other SAT-based algorithms)
// for finite-state functional transition systems
//
// Simulation support
//
// Author: Alberto Griggio <griggio@fbk.eu>
// See LICENSE.txt for copyright/licensing information
// See CREDITS.txt for other credits
//

#ifndef SIMPLIC3_MODELSIM_H
#define SIMPLIC3_MODELSIM_H

#include "simplic3/model.h"

namespace simplic3 {

class ModelSim {
public:
    enum value {
        FALSE = 0,
        TRUE,
        UNDEF
    };
    typedef HashMap<Aig, value> ValMap;
    
    ModelSim(Model *model);
    ~ModelSim();

    void init(const std::vector<value> &initial_state);
    void step(const std::vector<value> &inputs);

    value get(Aig a);

private:
    value mkval(value v, bool neg);
    value mkand(value l, value r);
    
    Model *model_;

    std::vector<value> current_;
    ValMap cache_;
    AigList to_process_;
};

} // namespace simplic3

#endif // SIMPLIC3_MODELSIM_H
