// -*- C++ -*-
// 
// SimplIC3: a "simple" implementation of IC3 (and other SAT-based algorithms)
// for finite-state functional transition systems
//
// Generic Prover interface
//
// Author: Alberto Griggio <griggio@fbk.eu>
// See LICENSE.txt for copyright/licensing information
// See CREDITS.txt for other credits
//

#include "prover.h"
#include "ic3.h"
#include "aic3.h"
#include "bmc.h"
#include "kinduction.h"

namespace simplic3 {

Prover *Prover::get(const std::string &name,
                    const Options &opts, Model *model, size_t property)
{
    if (name == "ic3") {
        return new IC3(opts, model, property);
    } else if (name == "aic3") {
        return new AbsIC3(opts, model, property);
    } else if (name == "bmc") {
        return new BMC(opts, model, property);
    } else if (name == "ind") {
        return new KInduction(opts, model, property);        
    } else {
        return NULL;
    }
}


std::vector<std::string> Prover::getnames()
{
    std::vector<std::string> ret;
    ret.push_back("ic3");
    ret.push_back("aic3");
    ret.push_back("bmc");
    ret.push_back("ind");

    return ret;
}

} // namespace simplic3
