// -*- C++ -*-
// 
// SimplIC3: a "simple" implementation of IC3 (and other SAT-based algorithms)
// for finite-state functional transition systems
//
// Generic SAT solver interface
//
// Author: Alberto Griggio <griggio@fbk.eu>
// See LICENSE.txt for copyright/licensing information
// See CREDITS.txt for other credits
//

#include "satsolver.h"

#ifdef SIMPLIC3_ENABLE_MINISAT
#  include "minisatsolver.h"
#endif

#ifdef SIMPLIC3_ENABLE_PICOSAT
#  include "picosatsolver.h"
#endif

#include <string>

namespace simplic3 {

namespace {

#ifdef SIMPLIC3_ENABLE_MINISAT
  MinisatSolverFactory minisat_core_factory(false);
  MinisatSolverFactory minisat_simp_factory(true);
#endif

#ifdef SIMPLIC3_ENABLE_PICOSAT
  PicosatSolverFactory picosat_factory;
#endif

} // namespace


SatSolverFactory::~SatSolverFactory()
{
}


SatSolverFactory *SatSolverFactory::get(const std::string &name)
{
    if (false) {
#ifdef SIMPLIC3_ENABLE_MINISAT
    } else if (name == "minisat") {
        return &minisat_simp_factory;
    } else if (name == "minisat-core") {
        return &minisat_core_factory;
#endif
#ifdef SIMPLIC3_ENABLE_PICOSAT
    } else if (name == "picosat") {
        return &picosat_factory;
#endif
    }
    return NULL;
}


std::vector<std::string> SatSolverFactory::getnames()
{
    std::vector<std::string> ret;
#ifdef SIMPLIC3_ENABLE_MINISAT
    ret.push_back("minisat");
    ret.push_back("minisat-core");
#endif
#ifdef SIMPLIC3_ENABLE_PICOSAT
    ret.push_back("picosat");
#endif
    return ret;
}

} // namespace simplic3
